/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.usage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.plan.WpaDurationVisitor;
import cz.insophy.inplan.report.usage.LpseEstimator;
import cz.insophy.inplan.report.usage.OldLpseEstimator;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.CalendarHelper;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.TimeSpan;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CapacityCollector {
    private static final int MAX_SLOTS = 3650;
    private long startDate;
    private long endDate;
    private Resolution resolution;
    private int dayStartHour;
    private RebuildMode rebuildMode;
    private TimeZone timeZone;
    private ImmutableList<Slot> slots;
    private final Superplan superplan;
    private Map<CapabilityIsland, IslandSummary> islandSummaries;
    private Predicate<GeneralizedOrderRequest> gorFilter;
    private LpseEstimator lpseEstimator;

    public CapacityCollector(Superplan superplan) {
        Preconditions.checkArgument(GeneralizedRequest.isDateValid(superplan.getFixationDate()), "fixation date must be set");
        this.superplan = superplan;
        this.startDate = superplan.getFixationDate();
        this.endDate = CalendarHelper.addMonths(this.startDate, 1);
        this.resolution = Resolution.DAY;
        this.dayStartHour = 0;
        this.timeZone = TimeZone.getDefault();
        this.rebuildMode = RebuildMode.DO_NOT_CONSIDER;
        this.gorFilter = CapacityCollector.allGorsFilter();
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public int getDayStartHour() {
        return this.dayStartHour;
    }

    public void setDayStartHour(int dayStartHour) {
        Preconditions.checkArgument(dayStartHour >= -23 && dayStartHour <= 23, "Invalid dateStartHour. Must be >= -23 and <= 23.");
        this.dayStartHour = dayStartHour;
    }

    public RebuildMode getRebuildMode() {
        return this.rebuildMode;
    }

    public void setRebuildMode(RebuildMode rebuildMode) {
        this.rebuildMode = rebuildMode;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(long endDate) {
        this.endDate = endDate;
    }

    public void setLpseEstimator(@Nullable LpseEstimator lpseEstimator) {
        this.lpseEstimator = lpseEstimator;
    }

    @Nonnull
    public Predicate<GeneralizedOrderRequest> getGorFilter() {
        return this.gorFilter;
    }

    public void setGorFilter(@Nonnull Predicate<GeneralizedOrderRequest> gorFilter) {
        this.gorFilter = Preconditions.checkNotNull(gorFilter);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    protected void createSlots() {
        ImmutableList.Builder slotsBuilder = ImmutableList.builder();
        slotsBuilder.add(new Slot(Long.MIN_VALUE, this.startDate, Long.MIN_VALUE));
        Calendar c = Calendar.getInstance(this.timeZone);
        c.setTimeInMillis(this.startDate);
        this.resolution.setStart(c);
        c.add(11, this.dayStartHour);
        long calStart = c.getTimeInMillis();
        c.add(11, -this.dayStartHour);
        if (calStart > this.startDate) {
            c.add(this.resolution.getField(), -1);
        }
        long start = this.startDate;
        for (int i = 0; start < this.endDate && i < 3650; ++i) {
            long formatStart = c.getTimeInMillis();
            c.add(this.resolution.getField(), 1);
            c.add(11, this.dayStartHour);
            long end = c.getTimeInMillis();
            c.add(11, -this.dayStartHour);
            if (start < end) {
                slotsBuilder.add(new Slot(start, end, formatStart));
            }
            start = end;
        }
        this.slots = slotsBuilder.build();
    }

    @VisibleForTesting
    ImmutableList<Slot> getSlots() {
        return this.slots;
    }

    private void createSummaries() {
        IdentityHashMap<CapabilityIsland, IslandSummary> islandSummaries = Maps.newIdentityHashMap();
        for (CapabilityIsland island : this.superplan.getShopConf().getIslands()) {
            islandSummaries.put(island, new IslandSummary(island));
        }
        this.islandSummaries = islandSummaries;
    }

    public void collect() {
        this.createSlots();
        this.createSummaries();
        for (IslandSummary ic : this.islandSummaries.values()) {
            ic.calcAvailableTime();
        }
        LpseEstimator lpseEstimator = this.lpseEstimator != null ? this.lpseEstimator : new OldLpseEstimator(this.superplan);
        HashBasedTable<SlotSummary, String, Boolean> usedRebuilds = HashBasedTable.create();
        for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
            if (!this.gorFilter.test(gor)) continue;
            block7: for (GeneralizedActionRequest gar : gor.getGars()) {
                if (gar.getOutOfPlanQty() >= gar.getRequestedQty() - 1.0E-7) continue;
                long lpe = lpseEstimator.getLpe(gar);
                Action a = gar.getAction();
                CapabilityIsland island = this.superplan.getShopConf().getIsland(a.getCapabilityReq());
                IslandSummary islandSummary = this.islandSummaries.get(island);
                SlotSummary slotSummary = islandSummary.getSlotSummary(lpe);
                if (slotSummary == null) continue;
                slotSummary.requested += a.normtime(gar.getRequestedQty() - gar.getOutOfPlanQty());
                switch (this.rebuildMode) {
                    case DO_NOT_CONSIDER: {
                        continue block7;
                    }
                    case CONSIDER: {
                        slotSummary.requested += this.getAverageRebuildTime(a);
                        continue block7;
                    }
                    case ONE_PER_SLOT: {
                        if (usedRebuilds.get(slotSummary, a.getRebuildType()) != null) continue block7;
                        slotSummary.requested += this.getAverageRebuildTime(a);
                        usedRebuilds.put(slotSummary, a.getRebuildType(), Boolean.TRUE);
                        continue block7;
                    }
                }
                throw new IllegalStateException(this.rebuildMode + " not implemented.");
            }
        }
        for (IslandSummary ic : this.islandSummaries.values()) {
            ic.cumulate();
        }
    }

    protected long getAverageRebuildTime(Action a) {
        List<Workplace> wps = this.superplan.getShopConf().getWorkplaces(a.getCapabilityReq());
        long rt = 0L;
        for (Workplace wp : wps) {
            rt += wp.getRebuildType(a.getRebuildType()).getTime();
        }
        return rt /= (long)wps.size();
    }

    @Nonnull
    public IslandSummary getIslandSummary(CapabilityIsland island) {
        IslandSummary islandSummary = this.islandSummaries.get(island);
        Preconditions.checkArgument(islandSummary != null, "Illegal island requested. %s", (Object)island);
        return islandSummary;
    }

    @Nonnull
    public Iterable<SlotSummary> getSlotSummaries() {
        ArrayList<List<SlotSummary>> allSums = Lists.newArrayListWithCapacity(this.islandSummaries.size());
        for (IslandSummary islCaps : this.islandSummaries.values()) {
            allSums.add(islCaps.getSlotSummaries());
        }
        return Iterables.concat(allSums);
    }

    @Nonnull
    public static Predicate<GeneralizedOrderRequest> allGorsFilter() {
        return Predicates.alwaysTrue();
    }

    @Nonnull
    public static Predicate<GeneralizedOrderRequest> highPriorityGorFilter(int maxPriority) {
        return gor -> gor != null && gor.getPriority() < maxPriority;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Resolution {
        DAY{

            @Override
            protected void setStart(Calendar c) {
                CalendarHelper.setDayStart(c);
            }

            @Override
            protected int getField() {
                return 5;
            }

            @Override
            protected Format createFormat(Locale l) {
                return new SimpleDateFormat(Formatter.getFormats().getShortDatetimeFormatPattern(), l);
            }
        }
        ,
        WEEK{

            @Override
            protected void setStart(Calendar c) {
                CalendarHelper.setWeekStart(c);
            }

            @Override
            protected int getField() {
                return 3;
            }

            @Override
            protected Format createFormat(Locale l) {
                return new SimpleDateFormat("YYYY 'W'ww", l);
            }
        }
        ,
        MONTH{

            @Override
            protected void setStart(Calendar c) {
                CalendarHelper.setMonthStart(c);
            }

            @Override
            protected int getField() {
                return 2;
            }

            @Override
            protected Format createFormat(Locale l) {
                return new SimpleDateFormat("LLLL yyyy", l);
            }
        };

        private final ThreadLocal<Map<Locale, Format>> formatters = ThreadLocal.withInitial(Maps::newHashMap);

        public String format(SlotSummary s2, Locale l) {
            if (s2.getStart() != Long.MIN_VALUE) {
                Map<Locale, Format> formatterMap = this.formatters.get();
                Format format = formatterMap.get(l);
                if (format == null) {
                    format = this.createFormat(l);
                    formatterMap.put(l, format);
                }
                return format.format(new Date(s2.getPeriodStart()));
            }
            return Localizer.getString("report.capacity_collector.delayed_slot");
        }

        protected abstract Format createFormat(Locale var1);

        protected abstract void setStart(Calendar var1);

        protected abstract int getField();

        public String format(SlotSummary s2) {
            return this.format(s2, Localizer.getCurrentLocale());
        }
    }

    public static enum RebuildMode {
        CONSIDER,
        DO_NOT_CONSIDER,
        ONE_PER_SLOT;

    }

    record Slot(long start, long end, long periodStart) {
    }

    public class IslandSummary {
        private final CapabilityIsland island;
        private final List<SlotSummary> summaries;

        private IslandSummary(CapabilityIsland island) {
            this.island = island;
            this.summaries = Lists.newArrayListWithCapacity(CapacityCollector.this.slots.size());
            for (Slot slot : CapacityCollector.this.slots) {
                this.summaries.add(new SlotSummary(island, slot));
            }
        }

        protected void calcAvailableTime() {
            for (Workplace wp : this.island.getWorkplaces()) {
                WorkplaceSchedule wps = CapacityCollector.this.superplan.getPlan().getWorkplaceSchedule(wp);
                for (SlotSummary summ : this.summaries) {
                    WpaDurationVisitor.DurationsSummary durs = WpaDurationVisitor.calculateDurations(wps, summ.getStart(), summ.getEnd());
                    long avail = summ.getLength() - durs.getOfflineTime();
                    if (summ.getStart() != Long.MIN_VALUE) {
                        summ.available += avail;
                    }
                    summ.used += durs.getActionTime() + durs.getRebuildTime();
                }
            }
        }

        @Nullable
        protected SlotSummary getSlotSummary(long time) {
            return TimeSpan.findEndInclusive(this.summaries, time);
        }

        protected void cumulate() {
            this.summaries.get(0).cumulateFrom(this.summaries.get(0));
            for (int i = 1; i < this.summaries.size(); ++i) {
                this.summaries.get(i).cumulateFrom(this.summaries.get(i - 1));
            }
        }

        public List<SlotSummary> getSlotSummaries() {
            return Collections.unmodifiableList(this.summaries);
        }
    }

    public static class SlotSummary
    extends TimeSpan {
        private static final long serialVersionUID = 1L;
        private final CapabilityIsland island;
        private final long periodStart;
        private long available;
        private long used;
        private long requested;
        private long availableCum;
        private long usedCum;
        private long requestedCum;

        private SlotSummary(CapabilityIsland island, Slot slot) {
            super(slot.start, slot.end);
            this.island = island;
            this.periodStart = slot.periodStart;
        }

        private void cumulateFrom(SlotSummary other) {
            this.availableCum = other.availableCum + this.available;
            this.usedCum = other.usedCum + this.used;
            this.requestedCum = other.requestedCum + this.requested;
        }

        public long getAvailable() {
            return this.available;
        }

        public long getUsed() {
            return this.used;
        }

        public long getRequested() {
            return this.requested;
        }

        public double getRequestedRatio() {
            return (double)this.requested / (double)this.available;
        }

        public double getUsedRatio() {
            return (double)this.used / (double)this.available;
        }

        public long getAvailableCum() {
            return this.availableCum;
        }

        public long getUsedCum() {
            return this.usedCum;
        }

        public long getRequestedCum() {
            return this.requestedCum;
        }

        public double getRequestedRatioCum() {
            return (double)this.requestedCum / (double)this.availableCum;
        }

        public double getUsedRatioCum() {
            return (double)this.usedCum / (double)this.availableCum;
        }

        public CapabilityIsland getIsland() {
            return this.island;
        }

        public long getPeriodStart() {
            return this.periodStart;
        }
    }
}

